<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Lib\RequiredConfig;
use App\Models\TimeInterval;
use Illuminate\Http\Request;

class TimeIntervalController extends Controller
{
    public function index()
    {
        $pageTitle      = 'Time Intervals';
        $timeIntervals        = TimeInterval::get();
        return view('admin.interval.index', compact('pageTitle', 'timeIntervals'));
    }

    public function store(Request $request, $id = 0)
    {
        $request->validate([
            'name' => 'required',
            'day' => 'required|integer|gt:0',
        ]);

        if ($id) {
            $day = TimeInterval::findOrFail($id);
            $notification = 'Timer interval updated successfully';
        } else {
            $day = new TimeInterval();
            $notification = 'Timer interval added successfully';
        }

        $day->name = $request->name;
        $day->day = $request->day;
        $day->save();

        RequiredConfig::configured('time_interval');
        $notify[] = ['success', $notification];
        return back()->withNotify($notify);
    }

    public function delete($id)
    {
        $timeInterval = TimeInterval::findOrFail($id);
        $timeInterval->delete();
        if ($timeInterval) {
            $notify[] = ['success', 'Time Interval deleted successfully'];
            return back()->withNotify($notify);
        }
    }
}
