<?php

namespace App\Http\Controllers\Staff;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Lib\GoogleAuthenticator;
use App\Models\PaidLog;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class StaffController extends Controller
{
    public function home()
    {
        $pageTitle = 'Dashboard';
        $widget['today_loan_collection_count'] = PaidLog::where('staff_id', auth('staff')->id())->whereDate('created_at', now()->format('Y-m-d'))->where('loan_id', '!=', 0)->count();
        $widget['today_loan_collection_amount'] = PaidLog::where('staff_id', auth('staff')->id())->whereDate('created_at', now()->format('Y-m-d'))->where('loan_id', '!=', 0)->sum('final_amount'); 
        $widget['today_savings_collection_count'] = PaidLog::where('staff_id', auth('staff')->id())->whereDate('created_at', now()->format('Y-m-d'))->where('savings_id', '!=', 0)->count();
        $widget['today_savings_collection_amount'] = PaidLog::where('staff_id', auth('staff')->id())->whereDate('created_at', now()->format('Y-m-d'))->where('savings_id', '!=', 0)->sum('final_amount');
        $payments = PaidLog::where('staff_id', auth('staff')->id())->success()->with('user', 'loan.loanPlan', 'savings.savingsPlan')->latest()->limit(10)->get();
        return view('staff.dashboard', compact('pageTitle','payments', 'widget'));
    }

    public function paymentHistory($filter = null, $adminReceive = null)
{
    $pageTitle = 'Payment History';
    $segment = request()->segment(3);

    $payments = PaidLog::where('staff_id', auth('staff')->id())->success();

    if ($filter == 'today') {
        $payments = $payments->whereDate('created_at', now()->format('Y-m-d'));
    } elseif ($filter != null) {
        $payments = $payments->whereDate('created_at', $filter);
    }

    if ($adminReceive !== null) {
        $payments = $payments->where('admin_receive', $adminReceive);
    }

    switch ($segment) {
        case 'loan':
            $payments = $payments->where('loan_id', '!=', 0)->with('loan.loanPlan');
            break;
        case 'savings':
            $payments = $payments->where('savings_id', '!=', 0)->with('savings.savingsPlan');
            break;
        default:
            $payments = $payments->with('loan.loanPlan', 'savings.savingsPlan');
            break;
    }

    $payments = $payments->with('user')->latest()->paginate(getPaginate());
    return view('staff.payment_history', compact('pageTitle', 'payments'));
}


    public function show2faForm()
    {
        $ga = new GoogleAuthenticator();
        $staff = auth()->guard('staff')->user();
        $secret = $ga->createSecret();
        $qrCodeUrl = $ga->getQRCodeGoogleUrl($staff->username . '@' . gs('site_name'), $secret);
        $pageTitle = '2FA Security';
        return view('staff.twofactor', compact('pageTitle', 'secret', 'qrCodeUrl'));
    }

    public function create2fa(Request $request)
    {
        $user = auth()->user();
        $request->validate([
            'key' => 'required',
            'code' => 'required',
        ]);
        $response = verifyG2fa($user, $request->code, $request->key);
        if ($response) {
            $user->tsc = $request->key;
            $user->ts = Status::ENABLE;
            $user->save();
            $notify[] = ['success', 'Two factor authenticator activated successfully'];
            return back()->withNotify($notify);
        } else {
            $notify[] = ['error', 'Wrong verification code'];
            return back()->withNotify($notify);
        }
    }

    public function disable2fa(Request $request)
    {
        $request->validate([
            'code' => 'required',
        ]);

        $user = auth()->user();
        $response = verifyG2fa($user, $request->code);
        if ($response) {
            $user->tsc = null;
            $user->ts = Status::DISABLE;
            $user->save();
            $notify[] = ['success', 'Two factor authenticator deactivated successfully'];
        } else {
            $notify[] = ['error', 'Wrong verification code'];
        }
        return back()->withNotify($notify);
    }


    public function checkUser(Request $request)
    {
        $user = User::where('username', $request->user)->orWhere('email', $request->user)->first();
        if(!$user){
            return false;
        }
        return $user;
    }
}
