<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class CheckStaffStatus
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Auth::guard('staff')->check()) {
            $staff = auth()->guard('staff')->user();
            if ($staff->status && $staff->ev && $staff->sv && $staff->tv) {
                return $next($request);
            } else {
                return to_route('staff.authorization');
            }
        }
        abort(403);
    }
}
