<?php

namespace App\Lib;

use App\Constants\Status;
use App\Models\Form;
use App\Models\Savings;

class SavingsProcess
{
    public $plan;
    public $user;
    public $installment;
    public $lateFee;
    public $amountWithLateFee;

    public function __construct($data)
    {
        $this->plan = @$data['plan'];
        $this->user = @$data['user'];
        $this->staffId = @$data['staff_id'];
    }
    public function apply()
    {
        $plan = $this->plan;
        $user = $this->user;
        $staffId = $this->staffId;
        $savings = new Savings();
        $request = request();
        $form = Form::where('act', 'savings_form')->where('id', $plan->form_id)->firstOrFail();
        $formData = $form->form_data;
        $formProcessor = new FormProcessor();
        $validationRule = $formProcessor->valueValidation($formData);
        $request->validate($validationRule);


        foreach (@$savings->user_information ?? [] as $userData) {
            if ($userData->type == 'file') {
                fileManager()->removeFile(getFilePath('verify') . '/' . $userData->value);
            }
        }
        $userData = $formProcessor->processFormData($request, $formData);
        $savings->user_information    =  $userData;
        
        $savings->user_id              = $user->id;
        $savings->staff_id             = $staffId ?? 0;
        $savings->savings_plan_id      = $plan->id;
        $savings->savings_amount       = $plan->savings_amount;
        $savings->installment          = $plan->installment;
        $savings->giveable_amount      = $plan->giveable_amount;
        $savings->installment_interval = $plan->installment_interval;
        $savings->total_installment    = $plan->total_installment;
        $savings->next_installment    = now()->addDays($plan->installment_interval);
        $savings->late_fee             = $plan->fixed_late_fee + ($plan->installment * $plan->percent_late_fee / 100);
        $savings->status               = Status::SAVINGS_PENDING;
        $savings->save();
        return;
    }

    public function installment($savings)
    {
        if ($savings->status == Status::SAVINGS_PENDING) {
            $notify[] = ['error', 'This savings has not been approved yet'];
            return [
                'error'  => true,
                'notify' => $notify
            ];
        } elseif ($savings->status == Status::SAVINGS_PAID) {
            $notify[] = ['error', 'All installments have been paid for this savings'];
            return [
                'error'  => true,
                'notify' => $notify
            ];
        } elseif ($savings->status == Status::SAVINGS_CLOSED) {
            $notify[] = ['error', 'This savings already closed'];
            return [
                'error'  => true,
                'notify' => $notify
            ];
        }

        $this->installmentCalculation($savings);
        return [
            'error' => false,
            'savings' => $savings
        ];
    }

    public function updateSavings($savings)
    {
        $this->installmentCalculation($savings);

        $savings->total_paid          += $this->installment;
        $savings->installment_given   += 1;
        $savings->total_late_fee_paid += $this->lateFee;
        $savings->last_installment     = now();
        $savings->next_installment     = $savings->next_installment->addDays($savings->installment_interval);

        if ($savings->total_installment == $savings->installment_given) {
            $savings->status = Status::SAVINGS_PAID;
        }
        $savings->save();
    }

    public function installmentCalculation($savings)
    {
        $lateFee                 = $savings->next_installment < now()->format('Y-m-d') ? $savings->late_fee : 0;
        $amountWithLateFee       = $savings->installment + $lateFee;
        $this->installment       = $savings->installment;
        $this->lateFee           = $lateFee;
        $this->amountWithLateFee = $amountWithLateFee;
    }
}
