<?php

namespace App\Models;

use App\Constants\Status;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

class Loan extends Model
{
    protected $casts = [
        'user_information' => 'object',
        'last_installment' => 'date',
        'next_installment' => 'date'
    ];

    public function loanPlan()
    {
        return $this->belongsTo(LoanPlan::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function staff()
    {
        return $this->belongsTo(Staff::class);
    }

    public function paidLogs()
    {
        return $this->hasMany(PaidLog::class);
    }

    //Scope
    public function scopePending()
    {
        return $this->where('status', Status::LOAN_PENDING);
    }

    public function scopeActive()
    {
        return $this->where('status', Status::LOAN_ACTIVE);
    }

    public function scopePaid()
    {
        return $this->where('status', Status::LOAN_PAID);
    }

    public function scopeClosed()
    {
        return $this->where('status', Status::LOAN_CLOSED);
    }

 
    public function statusBadge(): Attribute
    {
        return new Attribute(function () {
            $html = '';
            if ($this->status == Status::LOAN_PENDING) {
                $html = '<span class="badge badge--warning">' . trans("Pending") . '</span>';
            } elseif ($this->status == Status::LOAN_ACTIVE) {
                $html = '<span class="badge badge--success">' . trans("Active") . '</span>';
            } elseif ($this->status == Status::LOAN_PAID) {
                $html = '<span class="badge badge--primary">' . trans("Paid") . '</span>';
            } elseif ($this->status == Status::LOAN_CLOSED) {
                $html = '<span class="badge badge--dark">' . trans("Closed") . '</span>';
            }
            return $html;
        });
    }
}
