<?php
namespace App\Traits;

use App\Constants\Status;

trait StaffNotify
{
    public static function notifyToStaff(){
        return [
            'allStaffs'      => 'All Staff',
            'selectedStaffs' => 'Selected Staffs',
            'notLoginStaffs' => 'Last Few Days Not Login Staffs',
            'bannedStaffs'   => 'Banned Staffs'
        ];
    }

    public function scopeSelectedStaffs($query)
    {
        return $query->whereIn('id', request()->user ?? []);
    }

    public function scopeAllStaffs($query)
    {
        return $query;
    }

  
    public function scopeBannedStaffs($query)
    {
        return $query->banned();
    }

   
    public function scopeNotLoginStaffs($query)
    {
        return $query->whereDoesntHave('loginLogs', function ($q) {
            $q->whereDate('created_at', '>=', now()->subDays(request()->number_of_days ?? 10));
        });
    }

}
