<?php

namespace App\Traits;

use App\Constants\Status;

trait UserNotify
{
    public static function notifyToUser()
    {
        return [
            'allUsers'                    => 'All Users',
            'selectedUsers'               => 'Selected Users',
            'withBalance'                 => 'With Balance Users',
            'emptyBalanceUsers'           => 'Empty Balance Users',
            'twoFaDisableUsers'           => '2FA Disable User',
            'twoFaEnableUsers'            => '2FA Enable User',
            'hasDepositedUsers'           => 'Deposited Users',
            'notDepositedUsers'           => 'Not Deposited Users',
            'pendingDepositedUsers'       => 'Pending Deposited Users',
            'rejectedDepositedUsers'      => 'Rejected Deposited Users',
            'topDepositedUsers'           => 'Top Deposited Users',
            'pendingTicketUser'           => 'Pending Ticket Users',
            'answerTicketUser'            => 'Answer Ticket Users',
            'closedTicketUser'            => 'Closed Ticket Users',
            'notLoginUsers'               => 'Last Few Days Not Login Users',
            'loanPlanPurchaseUsers'       => 'Loan Plan Purchased Users',
            'savingsPlanPurchaseUsers'    => 'Savings Plan Purchased Users',
            'notLoanPlanPurchaseUsers'    => 'Not Loan Plan Purchased Users',
            'notSavingsPlanPurchaseUsers' => 'Not Savings Plan Purchased Users',
            'loanPlanPaidUsers'           => 'Loan Plan Paid Users',
            'savingsPlanPaidUsers'        => 'Savings Plan Paid Users',
            'loanPlanActiveUsers'         => 'Loan Plan Active Users',
            'savingsPlanActiveUsers'      => 'Savings Active paid Users',
            'loanPlanPendingUsers'        => 'Loan Plan Pending Users',
            'savingsPlanPendingUsers'     => 'Savings Pending paid Users',
        ];
    }


    public function scopeLoanPlanActiveUsers($query)
    {
        return $query->whereHas('loans', function ($loan) {
            $loan->active();
        });
    }
    public function scopeSavingsPlanActiveUsers($query)
    {
        return $query->whereHas('savings', function ($savings) {
            $savings->active();
        });
    }
    public function scopeLoanPlanPendingUsers($query)
    {
        return $query->whereHas('loans', function ($loan) {
            $loan->pending();
        });
    }
    public function scopeSavingsPlanPendingUsers($query)
    {
        return $query->whereHas('savings', function ($savings) {
            $savings->pending();
        });
    }
    public function scopeLoanPlanPaidUsers($query)
    {
        return $query->whereHas('loans', function ($loan) {
            $loan->paid();
        });
    }
    public function scopeSavingsPlanPaidUsers($query)
    {
        return $query->whereHas('savings', function ($savings) {
            $savings->paid();
        });
    }
    public function scopeLoanPlanPurchaseUsers($query)
    {
        return $query->whereHas('loans');
    }
    public function scopeSavingsPlanPurchaseUsers($query)
    {
        return $query->whereHas('savings');
    }
    public function scopeNotLoanPlanPurchaseUsers($query)
    {
        return $query->whereDoesntHave('loans');
    }
    public function scopeNotSavingsPlanPurchaseUsers($query)
    {
        return $query->whereDoesntHave('savings');
    }

    public function scopeSelectedUsers($query)
    {
        return $query->whereIn('id', request()->user ?? []);
    }

    public function scopeAllUsers($query)
    {
        return $query;
    }

    public function scopeEmptyBalanceUsers($query)
    {
        return $query->where('balance', '<=', 0);
    }

    public function scopeTwoFaDisableUsers($query)
    {
        return $query->where('ts', Status::DISABLE);
    }

    public function scopeTwoFaEnableUsers($query)
    {
        return $query->where('ts', Status::ENABLE);
    }

    public function scopeHasDepositedUsers($query)
    {
        return $query->whereHas('deposits', function ($deposit) {
            $deposit->successful();
        });
    }

    public function scopeNotDepositedUsers($query)
    {
        return $query->whereDoesntHave('deposits', function ($q) {
            $q->successful();
        });
    }

    public function scopePendingDepositedUsers($query)
    {
        return $query->whereHas('deposits', function ($deposit) {
            $deposit->pending();
        });
    }

    public function scopeRejectedDepositedUsers($query)
    {
        return $query->whereHas('deposits', function ($deposit) {
            $deposit->rejected();
        });
    }

    public function scopeTopDepositedUsers($query)
    {
        return $query->whereHas('deposits', function ($deposit) {
            $deposit->successful();
        })->withSum(['deposits' => function ($q) {
            $q->successful();
        }], 'amount')->orderBy('deposits_sum_amount', 'desc')->take(request()->number_of_top_deposited_user ?? 10);
    }

    public function scopePendingTicketUser($query)
    {
        return $query->whereHas('tickets', function ($q) {
            $q->whereIn('status', [Status::TICKET_OPEN, Status::TICKET_REPLY]);
        });
    }

    public function scopeClosedTicketUser($query)
    {
        return $query->whereHas('tickets', function ($q) {
            $q->where('status', Status::TICKET_CLOSE);
        });
    }

    public function scopeAnswerTicketUser($query)
    {
        return $query->whereHas('tickets', function ($q) {

            $q->where('status', Status::TICKET_ANSWER);
        });
    }

    public function scopeNotLoginUsers($query)
    {
        return $query->whereDoesntHave('loginLogs', function ($q) {
            $q->whereDate('created_at', '>=', now()->subDays(request()->number_of_days ?? 10));
        });
    }
}
