@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('S.N.')</th>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Day')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($timeIntervals as $interval)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ __($interval->name) }}</td>
                                        <td>{{ __($interval->day) }} @lang('Days')</td>
                                        <td>
                                            <div class="button--group">
                                                <button class="btn btn-sm btn-outline--primary cuModalBtn edit-btn" data-modal_title="@lang('Update Time Interval')" data-id="{{ $interval->id }}" data-name="{{ $interval->name }}" data-day="{{ $interval->day }}">
                                                    <i class="las la-pen"></i> @lang('Edit')
                                                </button>
                                                <button class="btn btn-sm btn-outline--danger confirmationBtn" data-action="{{ route('admin.time.intervals.delete', $interval->id) }}" data-question="@lang('Are you sure to delete this interval?')">
                                                    <i class="la la-trash"></i> @lang('Delete')
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="cuModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="{{ route('admin.time.intervals.store') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>@lang('Name')</label>
                            <input class="form-control" id="name" name="name" type="text" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Day')</label>
                            <div class="input-group">
                                <input class="form-control" id="day" name="day" type="text" required>
                                <span class="input-group-text">@lang('Day')</span>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--primary h-45 w-100" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <button class="btn btn-outline--primary btn-sm cuModalBtn add-btn" data-modal_title="@lang('Add New')">
        <i class="las la-plus"></i> @lang('Add New')
    </button>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            $('.removeBtn').on('click', function() {
                var modal = $('#removeModal');
                modal.find('input[name=id]').val($(this).data('id'));
            });

            $('.add-btn').on('click', function() {
                var modal = $('#cuModal');
                var route = '{{ route('admin.time.intervals.store') }}';
                $('#cuModal form').attr('action', route)
                $('#cuModal .modal-title').text($(this).data('modal_title'))
                $('#cuModal #size').val('')
                modal.modal('show');
            });

            $('.edit-btn').on('click', function(e) {
                var modal = $('#cuModal');
                var data = $(this).data();

                $('#cuModal #name').val(data.name)
                $('#cuModal #day').val(data.day)
                var route = '{{ route('admin.time.intervals.store', '') }}' + '/' + data.id;
                $('#cuModal form').attr('action', route)
                $('#cuModal .modal-title').text(data.modal_title)
                modal.modal('show');
            });

        })(jQuery);
    </script>
@endpush
