@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h5>@lang('Loan Information')</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Loan Plan'):
                            <span class="loan-plan">{{ __($loan->loanPlan->name) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Loan Amount'):
                            <span class="loan-amount">{{ showAmount($loan->loan_amount) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Payable Amount'):
                            <span class="total-payable">{{ showAmount($loan->payable_amount) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Type'):
                            <span class="installment-type">{{ installmentInterval($loan->installment_interval, $days) }} @lang('Payable')</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Amount')
                            <span class="installment">{{ showAmount($loan->installment) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Total Installment')
                            <span class="installment-times">{{ $loan->total_installment }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Applied Date')
                            <span class="installment-times">{{ showDateTime($loan->created_at) }}</span>

                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Status')
                            @if ($loan->status == Status::LOAN_PENDING)
                                <span class="badge badge--warning">@lang('Pending')</span>
                            @else
                                <span class="badge badge--success">@lang('Approved')</span>
                            @endif
                        </li>
                        <li class="list-group-item">
                            @lang('Description')
                            <hr class="mt-1 mb-2">
                            @php
                                echo $loan->loanPlan->description;
                            @endphp
                        </li>
                    </ul>
                </div>
            </div>
            <div class="card my-3">
                <div class="card-header">
                    <h5>@lang('User Information')</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('User Name'):
                            <span class="user-name">{{ __($loan->user->fullname) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('User Email'):
                            <span class="user-email">{{ $loan->user->email }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('More About User')
                            <span class="user-email">
                                <a class="btn btn-outline--primary" href="{{ route('admin.users.detail', $loan->user->id) }}">@lang('View Details')</a>
                            </span>
                        </li>
                    </ul>
                </div>
            </div>
            @if ($loan->staff_id)
                <div class="card">
                    <div class="card-header">
                        <h5>@lang('Loan Applied Staff Information')</h5>
                    </div>
                    <div class="card-body">
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Staff Name'):
                                <span class="staff-name">{{ __($loan->staff->fullname) }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Staff Email'):
                                <span class="staff-email">{{ $loan->staff->email }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('More About Staff')
                                <span class="staff-email">
                                    <a class="btn btn-outline--primary" href="{{ route('admin.staffs.detail', $loan->staff->id) }}">@lang('View Details')</a>
                                </span>
                            </li>
                        </ul>
                    </div>
                </div>
            @endif
        </div>
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h5>@lang('User Documentation')</h5>
                </div>
                <div class="card-body">
                    @if ($loan->user_information)
                        <ul class="list-group">
                            @foreach ($loan->user_information as $val)
                                @continue(!$val->value)
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    {{ __($val->name) }}
                                    <span>
                                        @if ($val->type == 'checkbox')
                                            {{ implode(',', $val->value) }}
                                        @elseif($val->type == 'file')
                                            <a href="{{ route('admin.download.attachment', encrypt(getFilePath('verify') . '/' . $val->value)) }}" class="me-3"><i class="fa-regular fa-file"></i> @lang('Attachment') </a>
                                        @else
                                            <p>{{ __($val->value) }}</p>
                                        @endif
                                    </span>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <h5 class="text-center">@lang('User data not found')</h5>
                    @endif

                    @if ($loan->status == Status::LOAN_PENDING)
                        <div class="mt-3">
                            <button class="btn btn-outline--primary w-100 h-45 confirmationBtn" data-action="{{ route('admin.loan.approve', $loan->id) }}" data-question="@lang('Are you sure to approved this loan?')" type="button">
                                <i class="la la-check"></i> @lang('Approve')
                            </button>
                        </div>
                    @endif
                </div>

            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.loan.pending') }}" />
@endpush
