@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('S.N.')</th>
                                    <th>@lang('Username')</th>
                                    <th>@lang('Loan Plan')</th>
                                    <th>@lang('Loan Amount')</th>
                                    <th>@lang('Installment')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($loans as $loan)
                                    <tr>
                                        <td>{{ $loans->firstItem() + $loop->index }}</td>
                                        <td><a href="{{ route('admin.users.detail', $loan->user->id) }}">{{ __($loan->user->username) }}</a></td>
                                        <td>{{ __($loan->loanPlan->name) }}</td>
                                        <td>{{ showAmount($loan->loan_amount) }}</td>
                                        <td>{{ showAmount($loan->installment) }}</td>
                                        <td>
                                            @php
                                                echo $loan->statusBadge;
                                            @endphp
                                        </td>
                                        <td>
                                            <div class="button--group">
                                                @if ($loan->status == Status::LOAN_PENDING)
                                                    <a class="btn btn-sm btn-outline--success ms-1 mb-2" data-toggle="tooltip" data-original-title="@lang('Details')" href="{{ route('admin.loan.details', $loan->id) }}"><i class="las la-desktop"></i> @lang('Details')
                                                    </a>
                                                @else
                                                    <button class="btn btn-sm btn-outline--success ms-1 mb-2 details-btn" data-toggle="tooltip" data-original-title="@lang('Details')" data-plan_name = "{{ __($loan->loanPlan->name) }}" data-interval="{{ installmentInterval($loan->installment_interval, $days) }}@lang(' Payable')" data-loan_amount = "{{ getAmount($loan->loan_amount) }}" data-payable_amount = "{{ getAmount($loan->payable_amount) }}" data-total_paid="{{ getAmount($loan->total_paid) }}" data-installment = "{{ getAmount($loan->installment) }}" data-late_fee = "{{ $loan->next_installment < now()->format('Y-m-d') ? getAmount($loan->late_fee) : 0 }}" data-installment_remaining="{{ $loan->total_installment - $loan->installment_given }}" data-installment_given="{{ $loan->installment_given }}" data-last_installment="{{ $loan->last_installment ? showDateTime($loan->last_installment, 'M-d, y') : '-' }}" data-next_installment="{{ $loan->status == Status::LOAN_ACTIVE ? showDateTime($loan->next_installment, 'M-d, y') : '-' }}" title="">
                                                        <i class="las la-desktop"></i> @lang('Details')
                                                    </button>
                                                @endif

                                                <button class="btn btn-sm btn-outline--primary ms-1 mb-2 installment-btn" data-toggle="tooltip" data-original-title="@lang('Take Installment')" data-loan_id="{{ $loan->id }}" data-user_email="{{ $loan->user->email }}" data-installment = "{{ getAmount($loan->installment) }}" data-amount="{{ getAmount($loan->installment) }}" data-late_fee="{{ $loan->next_installment < now()->format('Y-m-d') ? getAmount($loan->late_fee) : 0 }}" title="" {{ $loan->status != Status::LOAN_ACTIVE ? 'disabled' : '' }}>
                                                    <i class="las la-comment-dollar"></i> @lang('Installment')
                                                </button>

                                                <button class="btn btn-sm btn-outline--danger ms-1 mb-2 close-btn" data-toggle="tooltip" data-original-title="@lang('Close Loan')" data-loan_id="{{ $loan->id }}" data-user_email="{{ $loan->user->email }}" data-due_amount="{{ showAmount($loan->payable_amount - $loan->paidLogs->sum('amount')) }}" data-late_fee="{{ $loan->next_installment < now()->format('Y-m-d') ? getAmount($loan->late_fee) : 0 }}" title="" {{ $loan->status != Status::LOAN_ACTIVE ? 'disabled' : '' }}>
                                                    <i class="las la-trash"></i> @lang('Closed')
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($loans->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($loans) }}
                    </div>
                @endif
            </div>
        </div>
    </div>



    {{-- LOAN DETAILS MODAL  --}}
    <div class="modal fade" id="loanModal" role="dialog" tabindex="-1">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        @lang('Loan Details')
                    </h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Loan Plan')
                            <span class="loan-plan"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Loan Amount')
                            <span class="loan-amount"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Total Payable')
                            <span class="total-payable"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Total Paid')
                            <span class="total-paid"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Total Due')
                            <span class="total-due"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Interval')
                            <span class="installment-interval"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Given')
                            <span class="installment-given"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Remaining')
                            <span class="installment-remaining"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment')
                            <span class="installment"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Late Fee')
                            <span class="late-fee"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Payable')
                            <span class="installment-payable"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Last Installment')
                            <span class="last-installment"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Next Installment')
                            <span class="next-installment"></span>
                        </li>

                    </ul>
                </div>
                <div class="modal-footer">
                    <button class="btn btn--dark" data-bs-dismiss="modal">@lang('Close')</button>
                </div>
            </div>
        </div>
    </div>



    {{-- CONFIRM INSTALLMENT MODAL --}}
    <div class="modal fade" id="installmentModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Loan Installment Taken Confirmation')</h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="{{ route('admin.loan.installment') }}" method="POST">
                    @csrf
                    <input name="loan_id" type="hidden">
                    <div class="modal-body">
                        <h6 class="mb-3">@lang('Is this installment taken')?</h6>
                        <ul class="list-group">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('User Email')
                                <span class="user-email"></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Installment')
                                <span class="installment"></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Late Fee')
                                <span class="late-fee"></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Installment Payable')
                                <span class="installment-payable"></span>
                            </li>
                        </ul>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--dark" data-bs-dismiss="modal" type="button">@lang('No')</button>
                        <button class="btn btn--primary" type="submit">@lang('Confirm')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- CLOSE MODAL --}}
    <div class="modal fade" id="closeModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Loan Close Confirmation')</h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="{{ route('admin.loan.close') }}" method="POST">
                    @csrf
                    <input name="loan_id" type="hidden">
                    <div class="modal-body">
                        <h6 class="mb-3">@lang('Are you sure to close this loan')?</h6>
                        <ul class="list-group">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('User email')
                                <span class="user-email"></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Total due amount')
                                <span class="due-amount"></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Late Fee')
                                <span class="late-fee"></span>
                            </li>
                        </ul>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--dark" data-bs-dismiss="modal" type="button">@lang('No')</button>
                        <button class="btn btn--primary" type="submit">@lang('Yes')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <x-search-form placeholder="Username / Email" />
@endpush

@push('script')
    <script>
        "use strict";
        (function($) {
            var curSym = `{{ gs('cur_sym') }}`;
            $('.details-btn').on('click', function() {
                var modal = $('#loanModal');
                var data = $(this).data();
                var installment = parseFloat(data.installment);
                var lateFee = parseFloat(data.late_fee);

                modal.find('.loan-plan').text(data.plan_name);
                modal.find('.loan-amount').text(curSym + data.loan_amount);
                modal.find('.total-payable').text(curSym + data.payable_amount);
                modal.find('.installment-interval').text(data.interval);
                modal.find('.total-paid').text(curSym + data.total_paid);
                modal.find('.total-due').text(curSym + (data.payable_amount - data.total_paid).toFixed(2));
                modal.find('.installment-remaining').text(data.installment_remaining);
                modal.find('.installment-given').text(data.installment_given);
                modal.find('.installment').text(curSym + installment);
                modal.find('.late-fee').text(curSym + lateFee.toFixed(2));
                modal.find('.installment-payable').text(curSym + (installment + lateFee).toFixed(2));
                modal.find('.last-installment').text(data.last_installment);
                modal.find('.next-installment').text(data.installment_remaining ? data.next_installment : '-');
                modal.modal('show');
            });

            $(document).on('click', '.installment-btn', function() {
                var modal = $('#installmentModal');
                var data = $(this).data();
                var lateFee = parseFloat(data.late_fee);
                var installment = parseFloat(data.installment);

                modal.find('[name=loan_id]').val(data.loan_id);
                modal.find('.user-email').text(data.user_email);
                modal.find('.installment').text(curSym + data.amount);
                modal.find('.late-fee').text(curSym + lateFee.toFixed(2));
                modal.find('.installment-payable').text(curSym + (installment + lateFee).toFixed(2));
                modal.modal('show');
            });

            $(document).on('click', '.close-btn', function() {
                var modal = $('#closeModal');
                var data = $(this).data();
                var lateFee = parseFloat(data.late_fee);

                modal.find('[name=loan_id]').val(data.loan_id);
                modal.find('.user-email').text(data.user_email);
                modal.find('.due-amount').text(curSym + data.due_amount);
                modal.find('.late-fee').text(curSym + lateFee.toFixed(2))
                modal.modal('show');
            });

        })(jQuery);
    </script>
@endpush
