@extends('admin.layouts.app')
@section('panel')
<div class="row">
    <div class="col-lg-12">
        <div class="card">
                <form action="{{ route('admin.loan.register.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('Search By: Username or Email')</label>
                                    <input class="form-control " name="user" type="text" value="{{ old('user') }}" required />
                                    <span class="text--danger email-check">@lang('No user found')</span>
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('User Name')</label>
                                    <input class="form-control user_info user_name" type="text" readonly />
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('User Mobile')</label>
                                    <input class="form-control user_info user_mobile" type="text" readonly />
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('User Address')</label>
                                    <input class="form-control user_info user_address" type="text" readonly />
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('User City')</label>
                                    <input class="form-control user_info user_city" type="text" readonly />
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('User Country')</label>
                                    <input class="form-control user_info user_country" type="text" readonly />
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('Select Loan Plan')</label>
                                    <select class="form-control select2" name="plan_id" required>
                                        <option value="" hidden>@lang('Select One')</option>
                                        @foreach ($plans as $plan)
                                            <option data-plan="{{ $plan }}" data-installment_interval="{{ __(installmentInterval($plan->installment_interval, $days)) }}@lang(' payable')" value="{{ $plan->id }}">{{ __($plan->name) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('Loan Amount') </label>
                                    <div class="input-group ">
                                        <input class="form-control loan_amount" type="text" readonly />
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('Payable Amount') </label>
                                    <div class="input-group ">
                                        <input class="form-control payable_amount" type="text" readonly />
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('Installment Interval') </label>
                                    <input class="form-control installment_interval" type="text" readonly />
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('Total Installment') </label>
                                    <div class="input-group ">
                                        <input class="form-control total_installment" type="text" readonly />
                                        <span class="input-group-text">@lang('Times')</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('Installment')</label>
                                    <div class="input-group ">
                                        <input class="form-control installment" type="text" readonly />
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button class="btn btn--primary w-100 h-45" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.loan.index') }}" />
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            $('.email-check').hide();

            $('[name=user]').on('change', function(e) {
                var user = e.target.value;
                var url = `{{ route('admin.users.check') }}`;

                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        '_token': "{{ csrf_token() }}",
                        'user': user
                    },
                    success: function(response) {
                        if (!response) {
                            $('.email-check').show();
                            $('.user_info').val('');
                            $('[type=submit]').attr('disabled', true);
                        } else {
                            $('.email-check').hide();
                            $('.user_name').val(response.firstname + ' ' + response.lastname);
                            $('.user_mobile').val(response.mobile);
                            $('.user_address').val(response.address);
                            $('.user_city').val(response.city);
                            $('.user_country').val(response.country_name);
                            $('[type=submit]').attr('disabled', false);
                        }
                    }
                });
            });

            $('[name=plan_id]').on('change', function(e) {
                var plan = e.target.value;
                var plan = $(this).find(':selected').data().plan;
                var payableAmount = parseFloat(plan.payable_amount).toFixed(2);
                $('.loan_amount').val(parseFloat(plan.loan_amount).toFixed(2));
                $('.payable_amount').val(payableAmount);
                $('.total_installment').val(plan.total_installment);
                $('.installment').val((payableAmount / plan.total_installment).toFixed(2));
                $('.installment_interval').val($(this).find(':selected').data('installment_interval'));
            });

        })(jQuery);
    </script>
@endpush
