@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <form action="{{ route('admin.plan.savings.store', @$plan->id) }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row mb-none-15">
                            <div class="col-lg-12 col-xl-4">
                                <div class="form-group">
                                    <label>@lang('Name')</label>
                                    <input class="form-control" name="name" type="text" value="{{ old('name', @$plan->name) }}" required />
                                </div>
                            </div>
                            <div class="col-sm-12 col-xl-4 col-lg-6">
                                <div class="form-group">
                                    <label class="w-100  receive-times">@lang('Per Installment')</label>
                                    <div class="input-group">
                                        <input class="form-control" name="per_installment" type="number" value="{{ old('per_installment', getAmount(@$plan->installment)) }}" step="any" />
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-xl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Total Installment')</label>
                                    <input class="form-control" name="total_installment" type="number" value="{{ old('total_installment', getAmount(@$plan->total_installment)) }}" step="any" required />
                                </div>
                            </div>
                            <div class="col-sm-12 col-xl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Installment Interval')</label>
                                    <select class="form-control" name="installment_interval" required>
                                        <option value="" hidden>@lang('Select One')</option>
                                        @foreach ($days as $day)
                                            <option value="{{ $day->day }}">{{ __($day->name) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-12 col-xl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Savings Amount')</label>
                                    <div class="input-group">
                                        <input class="form-control savings-amount" type="number" value="{{ old('savings_amount', getAmount(@$plan->savings_amount)) }}" step="any" readonly />
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-xl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Giveable Amount')</label>
                                    <div class="input-group">
                                        <input class="form-control" name="giveable_amount" type="number" value="{{ old('giveable_amount', getAmount(@$plan->giveable_amount)) }}" step="any" required />
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-xl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Fixed Late Fee')</label>
                                    <div class="input-group">
                                        <input class="form-control" name="fixed_late_fee" type="number" value="{{ old('fixed_late_fee', getAmount(@$plan->fixed_late_fee)) }}" step="any" />
                                        <span class="input-group-text">{{ gs('cur_text') }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-xl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Percent Late Fee')</label>
                                    <div class="input-group">
                                        <input class="form-control" name="percent_late_fee" type="number" value="{{ old('percent_late_fee', getAmount(@$plan->percent_late_fee)) }}" step="any" />
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-xl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Profit')</label>
                                    <div class="input-group">
                                        <input class="form-control profit" type="number" step="any" readonly />
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group mt-3">
                                <label class=" ">@lang('Description')</label>
                                <textarea class="form-control border-radius-5 nicEdit" name="description" rows="8">{{ old('description', @$plan->description) }}</textarea>
                            </div>
                            <div class="col-lg-12">
                                <div class="submitRequired bg--warning form-change-alert d-none mt-3"><i class="fas fa-exclamation-triangle"></i> @lang('You\'ve to click on the submit button to apply the changes')</div>
                                <div class="card border--primary mt-3">
                                    <div class="card-header bg--primary d-flex justify-content-between">
                                        <h5 class="text-white">@lang('User Data')</h5>
                                        <button class="btn btn-sm btn-outline-light float-end form-generate-btn" type="button"> <i class="la la-fw la-plus"></i>@lang('Add New')</button>
                                    </div>
                                    <div class="card-body">
                                        <x-generated-form :form=@$form />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button class="btn btn--primary w-100 h-45" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-form-generator-modal />
@endsection

@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.plan.savings.index') }}" />
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            $('[name=installment_interval]').val({{ old('installment_interval') ?? @$plan->installment_interval }})

            receivableCal();

            $('[name=per_installment], [name=giveable_amount], [name=total_installment]').on('input', function(e) {
                receivableCal();
            });

            function receivableCal() {
                var perInstallment = parseInt($('[name=per_installment]').val());
                var totalInstallment = parseInt($('[name=total_installment]').val());
                var giveableAmount = parseInt($('[name=giveable_amount]').val());
                var savingsAmount = perInstallment * totalInstallment;

                $('.savings-amount').val(savingsAmount.toFixed(2));
                $('.profit').val(giveableAmount - savingsAmount);
            }

        })(jQuery);
    </script>
@endpush
