@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h5>@lang('Savings Information')</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Savings Plan'):
                            <span class="savings-plan">{{ __($savings->savingsPlan->name) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Savings Amount'):
                            <span class="savings-amount">{{ showAmount($savings->savings_amount) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Receivable Amount'):
                            <span class="total-giveable">{{ showAmount($savings->giveable_amount) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Type'):
                            <span class="installment-type">{{ installmentInterval($savings->installment_interval, $days) }} @lang('Payable')</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Amount')
                            <span class="installment">{{ showAmount($savings->installment) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Total Installment')
                            <span class="installment-times">{{ $savings->total_installment }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Status')
                            @if ($savings->status == Status::SAVINGS_PENDING)
                                <span class="badge badge--warning">@lang('Pending')</span>
                            @else
                                <span class="badge badge--success">@lang('Approved')</span>
                            @endif
                        </li>
                        <li class="list-group-item">
                            @lang('Description')
                            <hr class="mt-1 mb-2">
                            @php
                                echo $savings->savingsPlan->description;
                            @endphp
                        </li>
                    </ul>
                </div>
            </div>
            <div class="card my-3">
                <div class="card-header">
                    <h5>@lang('User Information')</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('User Name'):
                            <span class="user-name">{{ __($savings->user->fullname) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('User Email'):
                            <span class="user-email">{{ $savings->user->email }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('More About User')
                            <span class="user-email">
                                <a class="btn btn-outline--primary" href="{{ route('admin.users.detail', $savings->user->id) }}">@lang('View Details')</a>
                            </span>
                        </li>
                    </ul>
                </div>
            </div>
            @if ($savings->staff_id)
                <div class="card my-3">
                    <div class="card-header">
                        <h5>@lang('Savings Applied Staff Information')</h5>
                    </div>
                    <div class="card-body">
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Staff Name'):
                                <span class="staff-name">{{ __($savings->staff->fullname) }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Staff Email'):
                                <span class="staff-email">{{ $savings->staff->email }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('More About Staff')
                                <span class="staff-email">
                                    <a class="btn btn-outline--primary" href="{{ route('admin.staffs.detail', $savings->staff->id) }}"> <i class="las la-desktop"></i> @lang('View Details')</a>
                                </span>
                            </li>
                        </ul>
                    </div>
                </div>
            @endif
        </div>
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h5>@lang('User Documentation')</h5>
                </div>
                <div class="card-body">
                    @if ($savings->user_information)
                        <ul class="list-group">
                            @foreach ($savings->user_information as $val)
                                @continue(!$val->value)
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    {{ __($val->name) }}
                                    <span>
                                        @if ($val->type == 'checkbox')
                                            {{ implode(',', $val->value) }}
                                        @elseif($val->type == 'file')
                                            <a href="{{ route('admin.download.attachment', encrypt(getFilePath('verify') . '/' . $val->value)) }}" class="me-3"><i class="fa-regular fa-file"></i> @lang('Attachment') </a>
                                        @else
                                            <p>{{ __($val->value) }}</p>
                                        @endif
                                    </span>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <h5 class="text-center">@lang('Savings data not found')</h5>
                    @endif

                    @if ($savings->status == Status::SAVINGS_PENDING)
                        <div class="mt-3">
                            <button class="btn btn-outline--primary h-45 confirmationBtn w-100" data-action="{{ route('admin.savings.approve', $savings->id) }}" data-question="@lang('Are you sure to approved this savings?')" type="button">
                                <i class="la la-check"></i> @lang('Approve')
                            </button>
                        </div>
                    @endif
                </div>

            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.savings.pending') }}" />
@endpush
