@extends('admin.layouts.app')
@section('panel')
    @php
        $maturedRoute = request()->routeIs('admin.savings.matured.pending') || request()->routeIs('admin.savings.matured.paid');
    @endphp
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('S.N.')</th>
                                    <th>@lang('User Name')</th>
                                    <th>@lang('Savings Plan')</th>
                                    <th>@lang('Savings Amount')</th>
                                    <th>@lang('Installment')</th>
                                    @if ($maturedRoute)
                                        <th>@lang('Transfer User')</th>
                                    @else
                                        <th>@lang('Status')</th>
                                    @endif
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($data->savings as $savings)
                                    <tr>
                                        <td>{{ $data->savings->firstItem() + $loop->index }}</td>
                                        <td><a href="{{ route('admin.users.detail', $savings->user->id) }}">{{ __($savings->user->username) }}</a></td>
                                        <td>{{ __($savings->savingsPlan->name) }}</td>
                                        <td>{{ showAmount($savings->savings_amount) }}</td>
                                        <td>{{ showAmount($savings->total_installment) }}</td>
                                        @if ($maturedRoute)
                                            <td>
                                                @if ($savings->transfer_user == 1)
                                                    <span class="text--small badge badge--success">@lang('Yes')</span>
                                                @else
                                                    <span class="text--small badge badge--warning">@lang('No')</span>
                                                @endif
                                            </td>
                                        @else
                                            <td>
                                                @php
                                                    echo $savings->statusBadge;
                                                @endphp
                                            </td>
                                        @endif
                                        <td>
                                            <div class="button--group">
                                                @if ($savings->status == Status::SAVINGS_PENDING)
                                                    <a class="btn btn-sm btn-outline--success" data-toggle="tooltip" data-original-title="@lang('Details')" href="{{ route('admin.savings.details', $savings->id) }}">
                                                        <i class="las la-desktop"></i> @lang('Details')
                                                    </a>
                                                @else
                                                    <button class="btn btn-sm btn-outline--success details-btn" data-toggle="tooltip" data-original-title="@lang('Details')" data-plan_name = "{{ __($savings->savingsPlan->name) }}" data-interval="{{ installmentInterval($savings->installment_interval, $data->days) }}@lang(' Payable')" data-savings_amount = "{{ getAmount($savings->savings_amount) }}" data-giveable_amount = "{{ getAmount($savings->giveable_amount) }}" data-total_paid="{{ getAmount($savings->total_paid) }}" data-installment = "{{ getAmount($savings->installment) }}" data-late_fee = "{{ $savings->next_installment < now()->format('Y-m-d') ? getAmount($savings->late_fee) : 0 }}" data-installment_remaining="{{ $savings->total_installment - $savings->installment_given }}" data-installment_given="{{ $savings->installment_given }}" data-last_installment="{{ $savings->last_installment ? showDateTime($savings->last_installment, 'M-d, y') : '-' }}" data-next_installment="{{ $savings->status == 1 ? showDateTime($savings->next_installment, 'M-d, y') : '-' }}" title="">
                                                        <i class="las la-desktop"></i>@lang('Details')
                                                    </button>
                                                @endif

                                                @if ($maturedRoute)
                                                    <button class="btn btn-sm btn-outline--primary transfer-btn" data-savings_id="{{ $savings->id }}" data-user_email="{{ $savings->user->email }}" data-amount="{{ showAmount($savings->giveable_amount) }}" {{ $savings->transfer_user == 1 ? 'disabled' : '' }}>
                                                        <i class="las la-check"></i>@lang('Transfer')
                                                    </button>
                                                @else
                                                    <button class="btn btn-sm btn-outline--primary installment-btn" data-toggle="tooltip" data-original-title="@lang('Take Installment')" data-savings_id="{{ $savings->id }}" data-user_email="{{ $savings->user->email }}" data-amount="{{ getAmount($savings->installment) }}" data-late_fee = "{{ $savings->next_installment < now() ? getAmount($savings->late_fee) : 0 }}" title="" {{ $savings->status != Status::SAVINGS_ACTIVE ? 'disabled' : '' }}>
                                                        <i class="las la-comment-dollar"></i>@lang('Installment')
                                                    </button>
                                                    <button class="btn btn-sm btn-outline--danger close-btn" data-toggle="tooltip" data-original-title="@lang('Close Savings')" data-savings_id="{{ $savings->id }}" data-user_email="{{ $savings->user->email }}" data-payable_amount="{{ getAmount($savings->savings_amount - $savings->paidLogs->sum('amount')) }}" title="" {{ $savings->status != Status::SAVINGS_ACTIVE ? 'disabled' : '' }}>
                                                        <i class="las la-trash"></i>@lang('Closed')
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($data->savings->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($data->savings) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    {{-- SAVINGS DETAILS MODAL --}}
    <div class="modal fade" id="savingsModal" role="dialog" tabindex="-1">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Savings Details')</h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>

                <div class="modal-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Savings Plan')
                            <span class="savings-plan"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Savings Amount')
                            <span class="savings-amount"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Total Giveable')
                            <span class="total-giveable"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Total Paid')
                            <span class="total-paid"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Remaining Payable')
                            <span class="remaining-payble"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Interval')
                            <span class="installment-interval"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Given')
                            <span class="installment-given"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Remaining')
                            <span class="installment-remaining"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment')
                            <span class="installment"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Late Fee')
                            <span class="late-fee"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment payable')
                            <span class="installment-payable"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Last Installment')
                            <span class="last-installment"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Next Installment')
                            <span class="next-installment"></span>
                        </li>

                    </ul>
                </div>
                <div class="modal-footer">
                    <button class="btn btn--dark" data-bs-dismiss="modal">@lang('Close')</button>
                </div>
            </div>
        </div>
    </div>

    {{-- CONFIRM INSTALLMENT MODAL --}}
    <div class="modal fade" id="installmentModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Savings Installment Taken Confirmation')</h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="{{ route('admin.savings.installment') }}" method="POST">
                    @csrf
                    <input name="savings_id" type="hidden">
                    <div class="modal-body">
                        <h6 class="mb-3">@lang('Is this installment taken')?</h6>
                        <ul class="list-group">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('User Email')
                                <span class="user-email"></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Installment')
                                <span class="installment"></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Late Fee')
                                <span class="late-fee"></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Installment Payable')
                                <span class="installment-payable"></span>
                            </li>
                        </ul>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--dark" data-bs-dismiss="modal" type="button">@lang('No')</button>
                        <button class="btn btn--primary" type="submit">@lang('Yes')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- CLOSE MODAL --}}
    <div class="modal fade" id="closeModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Savings Close Confirmation')</h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="{{ route('admin.savings.close') }}" method="POST">
                    @csrf
                    <input name="savings_id" type="hidden">
                    <div class="modal-body">
                        <h6 class="mb-3">@lang('Are you sure to close this savings')?</h6>
                        <ul class="list-group">
                            <li class="list-group-item d-flex justify-content-between align-items-center">@lang('User email'):<span class="user-email"></span></li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">@lang('Total payable amount'):<span class="payable-amount"></span></li>
                        </ul>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--dark" data-bs-dismiss="modal" type="button">@lang('No')</button>
                        <button class="btn btn--primary" type="submit">@lang('Yes')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- TRANSFER MODAL --}}
    <div class="modal fade" id="transferModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Matured Savings Balance Transfer Confirmation')</h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="{{ route('admin.savings.matured.transfer') }}" method="POST">
                    @csrf
                    <input name="savings_id" type="hidden">
                    <div class="modal-body">
                        <h6 class="mb-3">@lang('Are you sure to transfer balance to this user')?</h6>
                        <ul class="list-group">
                            <li class="list-group-item d-flex justify-content-between align-items-center">@lang('User email'):<span class="user-email"></span></li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">@lang('Total payable amount'):<span class="giveable-amount"></span></li>
                        </ul>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--primary w-100 h-45" type="submit">@lang('Transfer Now')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <x-search-form placeholder="Username / Email" />
@endpush

@push('script')
    <script>
        "use strict";
        (function($) {
            var curSym = `{{ gs('cur_sym') }}`;
            $('.details-btn').on('click', function() {
                var modal = $('#savingsModal');
                var data = $(this).data();
                var installment = parseFloat(data.installment);
                var lateFee = parseFloat(data.late_fee);

                modal.find('.savings-plan').text(data.plan_name);
                modal.find('.savings-amount').text(curSym + data.savings_amount);
                modal.find('.total-giveable').text(curSym + data.giveable_amount);
                modal.find('.total-paid').text(curSym + data.total_paid);
                modal.find('.installment-interval').text(data.interval);
                modal.find('.remaining-payble').text(curSym + (data.savings_amount - data.total_paid).toFixed(2));
                modal.find('.installment-remaining').text(data.installment_remaining);
                modal.find('.installment-given').text(data.installment_given);
                modal.find('.installment').text(curSym + installment);
                modal.find('.late-fee').text(curSym + lateFee.toFixed(2));
                modal.find('.installment-payable').text(curSym + (installment + lateFee).toFixed(2));
                modal.find('.last-installment').text(data.last_installment);
                modal.find('.next-installment').text(data.installment_remaining ? data.next_installment : '-');

                modal.modal('show');
            });

            $(document).on('click', '.installment-btn', function() {
                var modal = $('#installmentModal');
                var data = $(this).data();
                var amount = parseFloat(data.amount);
                var lateFee = parseFloat(data.late_fee);

                modal.find('[name=savings_id]').val($(this).data('savings_id'));
                modal.find('.user-email').text(data.user_email);
                modal.find('.installment').text(curSym + amount);
                modal.find('.late-fee').text(curSym + lateFee.toFixed(2));
                modal.find('.installment-payable').text(curSym + (amount + lateFee).toFixed(2));
                modal.modal('show');
            });

            $(document).on('click', '.close-btn', function() {
                var modal = $('#closeModal');
                modal.find('[name=savings_id]').val($(this).data('savings_id'));
                modal.find('.user-email').text($(this).data('user_email'));
                modal.find('.payable-amount').text(curSym + $(this).data('payable_amount'));
                modal.modal('show');
            });

            $(document).on('click', '.transfer-btn', function() {
                var modal = $('#transferModal');
                modal.find('[name=savings_id]').val($(this).data('savings_id'));
                modal.find('.user-email').text($(this).data('user_email'));
                modal.find('.giveable-amount').text(curSym + $(this).data('amount'));
                modal.modal('show');
            });

        })(jQuery);
    </script>
@endpush
