@extends('staff.layouts.app')

@section('panel')
    <div class="row gy-4">
        <div class="col-xxl-3 col-sm-6">
            <x-widget
                      value="{{ $widget['today_loan_collection_count'] }}" title="Today Loan Collections" style="6" link="{{ route('staff.payment.loan.history', 'today') }}" icon="las la-money-bill-wave" bg="primary" />
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <x-widget
                      value="{{ showAmount($widget['today_loan_collection_amount']) }}" title="Total Loan Collection" style="6" link="{{ route('staff.payment.loan.history', 'today') }}" icon="las la-comments-dollar" bg="cyan" />
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <x-widget
                      value="{{ $widget['today_savings_collection_count'] }}" title="Today Savings Collection" style="6" link="{{ route('staff.payment.savings.history', 'today') }}" icon="las la-money-check-alt" bg="success" />
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <x-widget
                      value="{{ showAmount($widget['today_savings_collection_amount']) }}" title="Today Savings Collection" style="6" link="{{ route('staff.payment.savings.history', 'today') }}" icon="las la-coins" bg="warning" />
        </div><!-- dashboard-w1 end -->
    </div><!-- row end-->

    <div class="row gy-4 mt-2">
        <div class="col-lg-12">
            <div class="d-flex justify-content-between pb-3">
                <h5 class="d-inline">@lang('Payment History')</h5>
                <a class="btn btn-outline--primary text-end" href="{{ route('staff.payment.history') }}"> <i class="las la-desktop"></i> @lang('View All')</a>
            </div>
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('User Name')</th>
                                    @if (request()->routeIs('staff.dashboard'))
                                        <th>@lang('Type')</th>
                                    @endif
                                    <th>@lang('Plan Name')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Late Fee')</th>
                                    <th>@lang('Final Amount')</th>
                                    <th>@lang('Payment At')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($payments as $payment)
                                    <tr>
                                        <td>{{ __($payment->user->fullname) }} <br>
                                            @<span>{{ $payment->user->username }}</span>
                                        </td>
                                        @if (request()->routeIs('staff.dashboard'))
                                        <td>{{ $payment->loan_id ? __('Loan') : __('Savings') }}</td>
                                        @endif
                                        <td>{{ $payment->loan_id ? __($payment->loan->loanPlan->name) : __($payment->savings->savingsPlan->name) }}</td>
                                        <td>{{ showAmount($payment->amount) }}</td>                                    
                                        <td>{{ showAmount($payment->late_fee) }}</td>                                    
                                        <td>{{ showAmount($payment->final_amount) }}</td>                                    
                                        <td>{{ showDateTime($payment->created_at) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">
                                            {{ __($emptyMessage) }}                                           
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
         .empty-message img{
            width: 50px;
            margin-bottom: 15px;
        }
    </style>
@endpush
