@extends('staff.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('S.N.')</th>
                                    <th>@lang('Username')</th>
                                    <th>@lang('Loan Plan')</th>
                                    <th>@lang('Total Payable')</th>
                                    @if (request()->routeIs('staff.loan.pending'))
                                        <th>@lang('Applied Date')</th>
                                    @else
                                        <th>@lang('Paid')</th>
                                    @endif
                                    <th>@lang('Installment')</th>
                                    @if (request()->routeIs('staff.loan.index'))
                                        <th>@lang('Status')</th>
                                    @endif
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($loans as $loan)
                                    <tr>
                                        <td>{{ $loans->firstItem() + $loop->index }}</td>
                                        <td>{{ __($loan->user->fullname) }} <br>
                                            <span class="text--primary">{{ $loan->user->username }}</span>
                                        </td>
                                        <td>{{ __($loan->loanPlan->name) }}</td>
                                        <td>{{ showAmount($loan->payable_amount) }}</td>
                                        @if (request()->routeIs('user.loan.pending'))
                                            <td>{{ showDateTime($loan->created_at) }}</td>
                                        @else
                                            <td>{{ showAmount($loan->total_paid) }}</td>
                                        @endif
                                        <td>{{ showAmount($loan->installment) }}</td>
                                        @if (request()->routeIs('staff.loan.index'))
                                            <td>
                                                @php
                                                    echo $loan->statusBadge;
                                                @endphp
                                            </td>
                                        @endif
                                        <td>
                                            @php
                                                $planName = __($loan->loanPlan->name);
                                                $interval = installmentInterval($loan->installment_interval, $days) . __(' Payable');
                                                $loanAmount = getAmount($loan->loan_amount);
                                                $payableAmount = getAmount($loan->payable_amount);
                                                $totalPaid = getAmount($loan->total_paid);
                                                $installment = getAmount($loan->installment);
                                                $isLate = $loan->next_installment < now()->format('Y-m-d');
                                                $lateFee = $isLate ? getAmount($loan->late_fee) : 0;
                                                $installmentsRemaining = $loan->total_installment - $loan->installment_given;
                                                $installmentsGiven = $loan->installment_given;
                                                $lastInstallment = $loan->last_installment ? showDateTime($loan->last_installment, 'M-d, y') : '-';
                                                $nextInstallment = $loan->status == Status::LOAN_ACTIVE ? showDateTime($loan->next_installment, 'M-d, y') : '-';
                                                $isLate = $loan->next_installment < now()->format('Y-m-d');
                                                $lateFee = $isLate ? getAmount($loan->late_fee) : 0;
                                                $isDisabled = $loan->status != Status::LOAN_ACTIVE;
                                            @endphp
                                            <div class="button--group">
                                                <button class="btn btn-sm btn-outline--primary details-btn"
                                                        data-plan_name             = "{{ $planName }}"
                                                        data-interval              = "{{ $interval }}"
                                                        data-loan_amount           = "{{ $loanAmount }}"
                                                        data-payable_amount        = "{{ $payableAmount }}"
                                                        data-total_paid            = "{{ $totalPaid }}"
                                                        data-installment           = "{{ $installment }}"
                                                        data-late_fee              = "{{ $lateFee }}"
                                                        data-installment_remaining = "{{ $installmentsRemaining }}"
                                                        data-installment_given     = "{{ $installmentsGiven }}"
                                                        data-last_installment      = "{{ $lastInstallment }}"
                                                        data-next_installment      = "{{ $nextInstallment }}">
                                                    <i class="las la-desktop"></i> @lang('Details')
                                                </button>

                                                <button class="btn btn-sm btn-outline--success installment-btn"
                                                        data-loan_id="{{ $loan->id }}"
                                                        data-installment="{{ getAmount($loan->installment) }}"
                                                        data-late_fee="{{ $lateFee }}"
                                                        {{ $isDisabled ? 'disabled' : '' }}>
                                                    <i class="las la-comment-dollar"></i> @lang('Installment')
                                                </button>

                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">
                                            {{ __($emptyMessage) }}
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($loans->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($loans) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    {{-- LOAN DETAILS MODAL  --}}
    <div class="modal fade" id="loanModal" role="dialog" tabindex="-1">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Loan Details')</h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Loan Plan'):
                            <span class="loan-plan"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Loan Amount'):
                            <span class="loan-amount"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Total Payable'):
                            <span class="total-payable"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Total Paid')
                            <span class="total-paid"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Total Due')
                            <span class="total-due"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Instalment Interval'):
                            <span class="installment-interval"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Given')
                            <span class="installment-given"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Remaining')
                            <span class="installment-remaining"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment')
                            <span class="installment"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Late Fee')
                            <span class="late-fee"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Payable')
                            <span class="installment-payable"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Last Installment')
                            <span class="last-installment"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Next Installment')
                            <span class="next-installment"></span>
                        </li>

                    </ul>
                </div>
                <div class="modal-footer">
                    <button class="btn btn--dark" data-bs-dismiss="modal">@lang('Close')</button>
                </div>
            </div>
        </div>
    </div>

    {{-- CONFIRM INSTALLMENT MODAL --}}
    <div class="modal fade" id="installmentModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Loan Installment Confirmation')</h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="{{ route('staff.loan.installment') }}" method="POST">
                    @csrf
                    <input name="loan_id" type="hidden">
                    <div class="modal-body">
                        <ul class="list-group mt-3">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Installment')
                                <span class="installment"></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Late Fee')
                                <span class="late-fee"></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Installment Payable')
                                <span class="installment-payable"></span>
                            </li>
                        </ul>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--primary btn-block" type="submit">@lang('Pay Now')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <x-search-form placeholder="username" />
@endpush

@push('style')
    <style>
        .empty-message img {
            width: 50px;
            margin-bottom: 15px;
        }
    </style>
@endpush

@push('script')
    <script>
        "use strict";
        (function($) {
            var curSym = `{{ gs('cur_sym') }}`;
            $('.details-btn').on('click', function() {
                var modal = $('#loanModal');
                var data = $(this).data();
                var installment = parseFloat(data.installment);
                var lateFee = parseFloat(data.late_fee);

                modal.find('.loan-plan').text(data.plan_name);
                modal.find('.loan-amount').text(curSym + data.loan_amount);
                modal.find('.total-payable').text(curSym + data.payable_amount);
                modal.find('.total-paid').text(curSym + data.total_paid);
                modal.find('.total-due').text(curSym + (data.payable_amount - data.total_paid).toFixed(2));
                modal.find('.installment-interval').text(data.interval);
                modal.find('.installment-remaining').text(data.installment_remaining);
                modal.find('.installment-given').text(data.installment_given);
                modal.find('.installment').text(curSym + installment);
                modal.find('.late-fee').text(curSym + lateFee.toFixed(2));
                modal.find('.installment-payable').text(curSym + (installment + lateFee).toFixed(2));
                modal.find('.last-installment').text(data.last_installment);
                modal.find('.next-installment').text(data.installment_remaining ? data.next_installment : '-');

                modal.modal('show');
            });

            $('.installment-btn').on('click', function() {
                var modal = $('#installmentModal');
                var data = $(this).data();
                var installment = parseFloat(data.installment);
                var lateFee = parseFloat(data.late_fee);

                $('[name=loan_id]').val(data.loan_id);
                $('.installment').text(curSym + installment.toFixed(2));
                $('.late-fee').text(curSym + lateFee.toFixed(2));
                $('.installment-payable').text(curSym + (installment + lateFee).toFixed(2))
                modal.modal('show');
            });

        })(jQuery);
    </script>
@endpush
