@extends('staff.layouts.app')
@section('panel')
    <div class="row">
        @forelse ($loanPlans as $plan)
            <div class="col-xl-4 col-md-6 my-4">
                <div class="card">
                    <div class="card-body p-4 p-xxl-5">
                        <div class="pricing-table">
                            <h4 class="package-name">{{ __($plan->name) }}</h4>
                            <h4 class="price">{{ showAmount($plan->installment) }}</h4>
                            <span class="badge badge--primary">{{ __(installmentInterval($plan->installment_interval, $days)) }}</span>
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                                    @lang('Loan amount')
                                    <span>{{ showAmount($plan->loan_amount) }}</span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                                    @lang('Payable amount')
                                    <span>{{ showAmount($plan->payable_amount) }}</span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                                    @lang('Total Installment')
                                    <span>{{ $plan->total_installment }}</span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                                    @lang('Late Fee')
                                    <span>{{ showAmount($plan->fixed_late_fee + ($plan->installment * $plan->percent_late_fee) / 100) }}</span>
                                </li>
                            </ul>
                            <a class="btn btn--primary w-100 h-45" href="{{ route('staff.loan.apply', $plan->id) }}">@lang('Apply Now')</a>
                        </div>
                    </div>
                </div><!-- card end -->
            </div>
        @empty
            <div class="empty-message text-center">
                <img src="{{ asset('assets/images/empty_list.png') }}" alt="empty">
                <br>
                {{ __($emptyMessage) }}
            </div>
        @endforelse

        {{ paginateLinks($loanPlans) }}
    </div>
@endsection
