@if (gs('multi_language'))
    @php
        $language = App\Models\Language::all();
        $activeLanguage = App\Models\Language::where('code', session('lang'))->first();
    @endphp
    <div class="custom--dropdown">
        <div class="custom--dropdown__selected dropdown-list__item flex-nowrap">
            <div>
                <div class="thumb">
                    <img src="{{ getImage(getFilePath('language') . '/' . $activeLanguage->image, getFileSize('language')) }}"
                         alt="image">
                </div>
            </div>
            <span class="text me-3 me-xxl-0 text-white">{{ __($activeLanguage->name) }}</span>
        </div>
        <ul class="dropdown-list">
            @foreach ($language as $item)
                @if ($item->id != $activeLanguage->id)
                    <li class="dropdown-list__item langSel" data-value="{{ $item->code }}">
                        <div>
                            <div class="thumb"> <img
                                     src="{{ getImage(getFilePath('language') . '/' . $item->image, getFileSize('language')) }}"
                                     alt="image">
                            </div>
                        </div>
                        <span class="text">{{ $item->name }}</span>
                    </li>
                @endif
            @endforeach
        </ul>
    </div>
    @push('style')
        <style>
            /* Custom Dropdown Css Start */
            @media (max-width: 991px) {
                .header-section .custom--dropdown {
                    display: inline-block;
                }
            }

            .custom--dropdown {
                position: relative;
                width: auto;
                min-width: 120px;
                border-radius: 5px;
            }

            @media (max-width:375px) {
                .custom--dropdown {
                    min-width: 115px;
                }
            }

            .custom--dropdown:after {
                content: "\f107";
                position: absolute;
                font-weight: 900;
                font-family: 'Line Awesome Free';
                top: 50%;
                right: 10px;
                transition: auto;
                transform: translateY(-50%);
                transition: .3s ease-in-out;
                font-size: 0.875rem;
                color: #fff;
            }

            .custom--dropdown.open:after {
                -webkit-transform: translateY(-50%) rotate(180deg);
                transform: translateY(-50%) rotate(180deg);
            }

            .custom--dropdown>.custom--dropdown__selected {
                cursor: pointer;
                padding: 0 10px;
                font-size: 0.875rem;
                color: #fff !important;
            }

            @media (max-width: 1199px) {
                .custom--dropdown>.custom--dropdown__selected {
                    padding: 0px 10px;
                }
            }

            .custom--dropdown>.dropdown-list {
                position: absolute;
                background-color: #fff;
                width: 100%;
                border-radius: 10px;
                -webkit-box-shadow: 0px 12px 24px rgba(21, 18, 51, 0.13);
                box-shadow: 0px 12px 24px rgba(21, 18, 51, 0.13);
                opacity: 0;
                overflow: hidden;
                transition: .25s ease-in-out;
                transform: scaleY(0);
                -webkit-transform-origin: top center;
                transform-origin: top center;
                top: 100%;
                margin-top: 10px;
                z-index: -1;
                visibility: hidden;
                max-height: 230px;
                overflow-y: auto !important;
            }

            .custom--dropdown>.dropdown-list::-webkit-scrollbar {
                width: 4px;
                height: 4px;
            }

            .custom--dropdown.open>.dropdown-list {
                -webkit-transform: scale(1);
                transform: scale(1);
                opacity: 1;
                visibility: visible;
                z-index: 999 !important;
                background: #fff !important
            }

            .dropdown-list>.dropdown-list__item {
                padding: 10px 15px;
                cursor: pointer;
                -webkit-transition: 0.3s;
                transition: 0.3s;
                font-size: 0.875rem;
                margin-right: 0 !important;
            }

            .dropdown-list>.dropdown-list__item:hover {
                background-color: hsl(var(--base)/7);
                color: #fff !important;
            }

            .dropdown-list>.dropdown-list__item,
            .custom--dropdown>.custom--dropdown__selected {
                display: flex;
                align-items: center;
                flex-wrap: wrap;
            }

            .dropdown-list>.dropdown-list__item .thumb,
            .custom--dropdown>.custom--dropdown__selected .thumb {
                max-width: 30px;
            }

            .dropdown-list__item .thumb img {
                border-radius: 50%;
                height: 20px;
                width: 20px;
            }

            .dropdown-list>.dropdown-list__item .text,
            .custom--dropdown>.custom--dropdown__selected .text {
                width: calc(100% - 30px);
                padding-left: 10px;
                white-space: nowrap;
            }

            .custom--dropdown__selected.dropdown-list__item .thumb .flag {
                border-radius: 50%;
                height: 20px;
                width: 20px;
            }

            /* Custom Dropdown Css End */
        </style>
    @endpush
    @push('script')
        <script>
            $('.custom--dropdown > .custom--dropdown__selected').on('click', function() {
                $(this).parent().toggleClass('open');
            });

            $('.custom--dropdown > .dropdown-list > .dropdown-list__item').on('click', function() {
                $('.custom--dropdown > .dropdown-list > .dropdown-list__item').removeClass('selected');
                $(this).addClass('selected').parent().parent().removeClass('open').children(
                    '.custom--dropdown__selected').html($(this).html());
            });

            $(document).on('keyup', function(evt) {
                if ((evt.keyCode || evt.which) === 27) {
                    $('.custom--dropdown').removeClass('open');
                }
            });
            $(document).on('click', function(evt) {
                if ($(evt.target).closest(".custom--dropdown > .custom--dropdown__selected").length === 0) {
                    $('.custom--dropdown').removeClass('open');
                }
            });
        </script>
    @endpush

@endif
