@extends('staff.layouts.app')

@section('panel')
    <div class="container">
        <div class="row justify-content-center mt-4">
            <div class="col-md-8">

                <div class="card custom--card">
                    <div class="card-body">
                        <form method="post">
                            @csrf
                            <div class="form-group">
                                <label>@lang('Current Password')</label>
                                <input type="password" class="form-control form--control" name="current_password" required autocomplete="current-password">
                            </div>
                            <div class="form-group">
                                <label>@lang('Password')</label>
                                <input type="password" class="form-control form--control @if (gs('secure_password')) secure-password @endif" name="password" required autocomplete="current-password">
                            </div>
                            <div class="form-group">
                                <label>@lang('Confirm Password')</label>
                                <input type="password" class="form-control form--control" name="password_confirmation" required autocomplete="current-password">
                            </div>
                            <div class="form-group">
                                <button type="submit" class="btn btn--primary h-45 w-100">@lang('Submit')</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@if (gs('secure_password'))
    @push('script-lib')
        <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
    @endpush
@endif
@if (gs('secure_password'))
    @push('style-lib')
        <link rel="stylesheet" href="{{ asset('assets/global/css/custom.css') }}">
    @endpush
    @push('style')
        <style>
            .input-popup p {
                color: #fff;
            }
        </style>
    @endpush
@endif
