@extends('staff.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('S.N.')</th>
                                    <th>@lang('Username')</th>
                                    <th>@lang('Savings Plan')</th>
                                    <th>@lang('Savings Amount')</th>
                                    @if (request()->routeIs('user.savings.pending'))
                                        <th>@lang('Applied Date')</th>
                                    @else
                                        <th>@lang('Paid')</th>
                                    @endif
                                    <th>@lang('Installment')</th>
                                    @if (request()->routeIs('staff.savings.index'))
                                        <th>@lang('Status')</th>
                                    @endif
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($savingsList as $savings)
                                    <tr>
                                        <td>{{ $savingsList->firstItem() + $loop->index }}</td>
                                        <td>{{ __($savings->user->fullname) }} <br>
                                            <span class="text--primary">{{ $savings->user->username }}</span>
                                        </td>
                                        <td>{{ __($savings->savingsPlan->name) }}</td>
                                        <td>{{ showAmount($savings->savings_amount) }}</td>
                                        @if (request()->routeIs('user.savings.pending'))
                                            <td>{{ showDateTime($savings->created_at) }}</td>
                                        @else
                                            <td>{{ showAmount($savings->total_paid) }}</td>
                                        @endif
                                        <td>{{ showAmount($savings->installment) }}</td>
                                        @if (request()->routeIs('staff.savings.index'))
                                            <td> @php echo $savings->statusBadge;  @endphp </td>
                                        @endif
                                        <td>
                                            @php
                                                // Details button variables
                                                $planName = __($savings->savingsPlan->name);
                                                $interval = installmentInterval($savings->installment_interval, $days) . __(' Payable');
                                                $savingsAmount = getAmount($savings->savings_amount);
                                                $giveableAmount = getAmount($savings->giveable_amount);
                                                $totalPaid = getAmount($savings->total_paid);
                                                $installment = getAmount($savings->installment);
                                                $isLate = $savings->next_installment < now()->format('Y-m-d');
                                                $lateFee = $isLate ? getAmount($savings->late_fee) : 0;
                                                $installmentsRemaining = $savings->total_installment - $savings->installment_given;
                                                $installmentsGiven = $savings->installment_given;
                                                $lastInstallment = $savings->last_installment ? showDateTime($savings->last_installment, 'M-d, y') : '-';
                                                $nextInstallment = $savings->status == Status::SAVINGS_ACTIVE ? showDateTime($savings->next_installment, 'M-d, y') : '-';

                                                // Installment button variables
                                                $savingsId = $savings->id;
                                                $isDisabled = $savings->status != Status::SAVINGS_ACTIVE;
                                            @endphp
                                            <div class="button--group">
                                                <button class="btn btn-sm btn-outline--primary ms-1 mb-2 details-btn"
                                                        data-toggle="tooltip"
                                                        title="@lang('Details')"
                                                        data-original-title="@lang('Details')"
                                                        data-plan_name="{{ $planName }}"
                                                        data-interval="{{ $interval }}"
                                                        data-savings_amount="{{ $savingsAmount }}"
                                                        data-giveable_amount="{{ $giveableAmount }}"
                                                        data-total_paid="{{ $totalPaid }}"
                                                        data-installment="{{ $installment }}"
                                                        data-late_fee="{{ $lateFee }}"
                                                        data-installment_remaining="{{ $installmentsRemaining }}"
                                                        data-installment_given="{{ $installmentsGiven }}"
                                                        data-last_installment="{{ $lastInstallment }}"
                                                        data-next_installment="{{ $nextInstallment }}">
                                                    <i class="las la-desktop"></i> @lang('Details')
                                                </button>

                                                <button class="btn btn-sm btn-outline--success ms-1 mb-2 installment-btn"
                                                        data-savings_id="{{ $savingsId }}"
                                                        data-installment="{{ $installment }}"
                                                        data-late_fee="{{ $lateFee }}"
                                                        {{ $isDisabled ? 'disabled' : '' }}>
                                                    <i class="las la-comment-dollar"></i> @lang('Installment')
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">
                                            {{ __($emptyMessage) }}
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($savingsList->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($savingsList) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div id="savingsModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Savings Details')</h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Savings Plan'):
                            <span class="savings-plan"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Savings Amount'):
                            <span class="savings-amount"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Total Receivable'):
                            <span class="total-receivable"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Total Paid')
                            <span class="total-paid"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Remaining Payable')
                            <span class="remaining-payble"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Interval'):
                            <span class="installment-interval"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Given')
                            <span class="installment-given"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment Remaining')
                            <span class="installment-remaining"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment')
                            <span class="installment"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Late Fee')
                            <span class="late-fee"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Installment payable')
                            <span class="installment-payable"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Last Installment')
                            <span class="last-installment"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Next Installment')
                            <span class="next-installment"></span>
                        </li>
                    </ul>
                </div>
                <div class="modal-footer">
                    <button class="btn btn--dark" data-bs-dismiss="modal">@lang('Close')</button>
                </div>
            </div>
        </div>
    </div>


    {{-- CONFIRM INSTALLMENT MODAL --}}
    <div id="installmentModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Savings Installment Confirmation')</h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="{{ route('staff.savings.installment') }}" method="POST">
                    @csrf
                    <input type="hidden" name="savings_id">
                    <div class="modal-body">
                        <ul class="list-group mt-3">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Installment')
                                <span class="installment"></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Late Fee')
                                <span class="late-fee"></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Installment Payable')
                                <span class="installment-payable"></span>
                            </li>
                        </ul>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Pay Now')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .empty-message img {
            width: 50px;
            margin-bottom: 15px;
        }
    </style>
@endpush

@push('script')
    <script>
        "use strict";
        (function($) {
            var curSym = `{{ gs('cur_sym') }}`;

            $('.details-btn').on('click', function() {
                var modal = $('#savingsModal');
                var data = $(this).data();
                var installment = parseFloat(data.installment);
                var lateFee = parseFloat(data.late_fee)

                modal.find('.savings-plan').text(data.plan_name);
                modal.find('.installment-interval').text(data.interval);
                modal.find('.savings-amount').text(curSym + data.savings_amount);
                modal.find('.total-receivable').text(curSym + data.giveable_amount);
                modal.find('.total-paid').text(curSym + data.total_paid);
                modal.find('.remaining-payble').text(curSym + (data.savings_amount - data.total_paid).toFixed(2));
                modal.find('.installment-remaining').text(data.installment_remaining);
                modal.find('.installment-given').text(data.installment_given);
                modal.find('.installment').text(curSym + installment);
                modal.find('.late-fee').text(curSym + lateFee.toFixed(2));
                modal.find('.installment-payable').text(curSym + (installment + lateFee).toFixed(2));
                modal.find('.last-installment').text(data.last_installment);
                modal.find('.next-installment').text(data.installment_remaining ? data.next_installment : '-');

                modal.modal('show');
            });

            $('.installment-btn').on('click', function() {
                var modal = $('#installmentModal');
                var data = $(this).data();
                var installment = parseFloat(data.installment);
                var lateFee = parseFloat(data.late_fee);

                $('[name=savings_id]').val(data.savings_id);
                $('.installment').text(curSym + installment.toFixed(2));
                $('.late-fee').text(curSym + lateFee.toFixed(2));
                $('.installment-payable').text(curSym + (installment + lateFee).toFixed(2))
                modal.modal('show');
            });

        })(jQuery);
    </script>
@endpush
