@extends('user.layouts.master')
@section('content')
    @php
        $loginContent = getContent('login.content', true);
    @endphp

    <div class="account--wrapper">
        <div class="account--thumb">
            <img src="{{ frontendImage('login', @$loginContent->data_values->image, '915x870') }}" alt="login" border="0" />
        </div>
        <div class="account--content">
            <div class="account--content-wrapper">
                <h2 class="d-flex justify-content-center py-3">{{ __(@$loginContent->data_values->heading) }}</h2>

                @include('user.partials.social_login')

                <form class="verify-gcaptcha" method="POST" action="{{ route('user.login') }}">
                    @csrf
                    <div class="form-group">
                        <label class="form-label" for="email">@lang('Username or Email')</label>
                        <input class="form-control form--control" name="username" type="text" value="{{ old('username') }}" required>
                    </div>
                    <div class="form-group">
                        <div class="d-flex flex-wrap justify-content-between mb-2">
                            <label class="form-label mb-0" for="password">@lang('Password')</label>
                            <a class="fw-bold forgot-pass" href="{{ route('user.password.request') }}">
                                @lang('Forgot your password?')
                            </a>
                        </div>
                        <input class="form-control form--control" id="password" name="password" type="password" required>
                    </div>

                    <x-captcha />

                    <div class="form-group form-check">
                        <input class="form-check-input" id="remember" name="remember" type="checkbox" {{ old('remember') ? 'checked' : '' }}>
                        <label class="form-check-label" for="remember">
                            @lang('Remember Me')
                        </label>
                    </div>

                    <div class="form-group">
                        <button class="btn btn--primary w-100 h-45" id="recaptcha" type="submit">
                            @lang('Login')
                        </button>
                    </div>
                    <p class="pb-5">@lang('Don\'t have any account?') <a href="{{ route('user.register') }}">@lang('Register')</a>
                    </p>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .verify-gcaptcha label {
            color: #000;
        }
    </style>
@endpush
