@extends('user.layouts.master')
@section('content')
    <div class="login-main" style="background-image: url('{{ asset('assets/admin/images/login.jpg') }}')">
        <div class="container custom-container">
            <div class="row justify-content-center">
                <div class="col-xxl-5 col-xl-5 col-lg-6 col-md-8 col-sm-11">
                    <div class="login-area">
                        <div class="login-wrapper">
                            <div class="login-wrapper__top">
                                <h3 class="title text-white">@lang('Recovery Account')</h3>
                            </div>
                            <div class="login-wrapper__body">
                                <form class="verify-gcaptcha" method="POST" action="{{ route('user.password.email') }}">
                                    @csrf
                                    <div class="form-group">
                                        <label>@lang('Email or Username')</label>
                                        <input class="form-control form--control" name="value" type="text" value="{{ old('value') }}" required autofocus="off">
                                    </div>

                                    <x-captcha />

                                    <div class="form-group">
                                        <button class="btn btn--primary h-45 w-100" type="submit">@lang('Submit')</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .form-control {
            color: #e7e7e7 !important;
        }

        .form-control:focus {
            color: #e7e7e7;
            background-color: transparent;
        }
    </style>
@endpush
