@extends('user.layouts.master')
@section('content')
    <div class="login-main" style="background-image: url('{{ asset('assets/admin/images/login.jpg') }}')">
        <div class="container custom-container">
            <div class="row justify-content-center">
                <div class="col-xxl-5 col-xl-5 col-lg-6 col-md-8 col-sm-11">
                    <div class="login-area">
                        <div class="login-wrapper">
                            <div class="login-wrapper__top">
                                <h3 class="title text-white">@lang('Reset Password')</h3>
                            </div>
                            <div class="login-wrapper__body">
                                <div class="mb-4">
                                    <p class="text-white">@lang('Your account is verified successfully. Now you can change your password. Please enter a strong password and don\'t share it with anyone.')</p>
                                </div>
                                <form method="POST" action="{{ route('user.password.update') }}">
                                    @csrf
                                    <input name="email" type="hidden" value="{{ $email }}">
                                    <input name="token" type="hidden" value="{{ $token }}">
                                    <div class="form-group">
                                        <label class="text-white">@lang('Password')</label>
                                        <input class="form-control form--control @if (gs('secure_password')) secure-password @endif" name="password" type="password" required>
                                    </div>
                                    <div class="form-group">
                                        <label class="text-white">@lang('Confirm Password')</label>
                                        <input class="form-control form--control" name="password_confirmation" type="password" required>
                                    </div>
                                    <div class="form-group">
                                        <button class="btn btn--primary w-100 h-45" type="submit"> @lang('Submit')</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@if (gs('secure_password'))
    @push('script-lib')
        <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
    @endpush
@endif
@if (gs('secure_password'))
    @push('style-lib')
        <link rel="stylesheet" href="{{ asset('assets/global/css/custom.css') }}">
    @endpush
    @push('style')
        <style>
            .input-popup p {
                color: #fff;
            }
        </style>
    @endpush
@endif


@push('style')
    <style>
        .form-control {
            color: #e7e7e7 !important;
        }

        .form-control:focus {
            color: #e7e7e7;
            background-color: transparent;
        }
    </style>
@endpush
