@extends('user.layouts.app')

@section('panel')

    <div class="notice"></div>

    <div class="row gy-4">
        <div class="col-xxl-3 col-sm-6">
            <x-widget
                      value="{{ $widget['active_loans'] }}" title="Active Loans" style="6" link="{{ route('user.loan.active') }}" icon="las la-comment-dollar" bg="primary" />
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <x-widget
                      value="{{ showAmount($widget['total_due']) }}" title="Total Due Loan" style="6" link="{{ route('user.loan.active') }}" icon="las la-file-invoice-dollar" bg="danger" />
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <x-widget
                      value="{{ $widget['active_savings'] }}" title="Active Savings" style="6" link="{{ route('user.savings.active') }}" icon="las la-coins" bg="success" />
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <x-widget
                      value="{{ showAmount($widget['payable_savings']) }}" title="Payable Savings" style="6" link="{{ route('user.savings.active') }}" icon="las la-wallet" bg="warning" />
        </div><!-- dashboard-w1 end -->
    </div><!-- row end-->

    <div class="row gy-4 mt-2">
        <div class="col-lg-12">
            <div class="d-flex justify-content-between pb-3">
                <h5 class="d-inline">@lang('Payment History')</h5>
                <a class="btn btn-outline--primary text-end" href="{{ route('user.payment.history') }}"> <i class="las la-desktop"></i> @lang('View All')</a>
            </div>
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Type')</th>
                                    <th>@lang('Plan Name')</th>
                                    <th>@lang('Paid Through')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Late Fee')</th>
                                    <th>@lang('Total Amount')</th>
                                    <th>@lang('Payment At')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($payments as $payment)
                                    <tr>
                                        <td>{{ $payment->loan_id ? __('Loan') : __('Savings') }}</td>
                                        <td>{{ $payment->loan_id ? __($payment->loan->loanPlan->name) : __($payment->savings->savingsPlan->name) }}</td>
                                        <td>
                                            @if ($payment->staff_id)
                                                @lang('Staff')
                                            @elseif(!$payment->trx)
                                                @lang('Admin')
                                            @else
                                                @lang('Self')
                                            @endif
                                        </td>
                                        <td>{{ showAmount($payment->amount) }}</td>
                                        <td>{{ showAmount($payment->late_fee) }}</td>
                                        <td>{{ showAmount($payment->final_amount) }}</td>
                                        <td>{{ showDateTime($payment->created_at) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">
                                            <div class="empty-message text-center">
                                                <img src="{{ asset('assets/images/empty_list.png') }}" alt="empty">
                                                <br>
                                            {{ __($emptyMessage) }}
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
         .empty-message img{
            width: 50px;
            margin-bottom: 15px;
        }
    </style>
@endpush
