@extends('user.layouts.app')
@section('panel')
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body p-0">
                <div class="table-responsive--md  table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                        <tr>
                            <th>@lang('S.N.')</th>
                            @if (request()->routeIs('user.payment.history'))
                                <th>@lang('Type')</th>
                            @endif
                            <th>@lang('Plan Name')</th>
                            <th>@lang('Paid Through')</th>
                            <th>@lang('Amount')</th>
                            <th>@lang('Late Fee')</th>
                            <th>@lang('Total Amount')</th>
                            <th>@lang('Payment At')</th>
                        </tr>
                        </thead>
                        <tbody>
                            @forelse ($payments as $payment)     
                                <tr>
                                    <td >{{ $loop->index + $payments->firstItem() }}</td>
                                    @if (request()->routeIs('user.payment.history'))
                                    <td>{{ $payment->loan_id ? __('Loan') : __('Savings') }}</td>
                                    @endif
                                    <td>{{ $payment->loan_id ? __($payment->loan->loanPlan->name) : __($payment->savings->savingsPlan->name) }}</td>
                                    <td> @if($payment->staff_id) @lang('Staff')  @elseif(!$payment->trx) @lang('Admin') @else @lang('Self') @endif</td>
                                    <td>{{ showAmount($payment->amount) }}</td>                                    
                                    <td>{{ showAmount($payment->late_fee) }}</td>                                    
                                    <td>{{ showAmount($payment->final_amount) }}</td>                                    
                                    <td>{{ showDateTime($payment->created_at) }}</td>
                                </tr>
                            @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            @if ($payments->hasPages())
                <div class="card-footer py-4">
                    {{ paginateLinks($payments) }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('breadcrumb-plugins')
    <x-search-form placeholder="Plan Name" />
@endpush